/*===================================================================================

  copyright: (C) Copyright 2003-2010 FileMaker, Inc. All Rights Reserved
  
  =================================================================================*/

function setupSortDlog()
{
	if( top == null || top.sortinfo == null || top.opener == null || top.opener.iwp == null )
	{
		top.close();
		return;
	}
	
	var iwp = top.opener.iwp;
	var strs = iwp.strings;
	iwp.sortdialog = top;
	if( strs != null  )
	{
		top.document.title = strs.sort_ttl_sort;
		var d = window.document;
		iwp.addOrReplaceTextNode( d, "orderBox", strs.sort_lbl_order );
		iwp.addOrReplaceTextNode( d, "chooseBox", strs.sort_lbl_choose );
		iwp.addOrReplaceTextNode( d, "ascendBox1", strs.sort_lbl_ascend1 );
		iwp.addOrReplaceTextNode( d, "ascendBox2", strs.sort_lbl_ascend2 );
		iwp.addOrReplaceTextNode( d, "decendBox1", strs.sort_lbl_decend1 );
		iwp.addOrReplaceTextNode( d, "decendBox2", strs.sort_lbl_decend2 );
		iwp.addOrReplaceTextNode( d, "customBox1", strs.sort_lbl_custom1 );
		iwp.addOrReplaceTextNode( d, "customBox2", strs.sort_lbl_custom2 );
		iwp.setAttribute( d, "cancelButton", "value", strs.stat_lbl_cancel );
		iwp.setAttribute( d, "clearButton", "value", strs.sort_btn_clearall );
		iwp.setAttribute( d, "moveButton", "value", strs.sort_btn_move );
		iwp.setAttribute( d, "sortButton", "value", strs.sort_btn_sort );
		iwp.setAttribute( d, "unsortButton", "value", strs.sort_btn_unsort );
		iwp.setupRollover( d, "helpButton", "help");
				
		var nav = null;
		var sflds = top.sortinfo.fields;
		var svals = top.sortinfo.vlists;
		var curord = top.sortinfo.currentorder;
		var dlg = d.getElementById( "dlogBox" );
		window.dlogBox = dlg;
		
		dlg.s1active			= null;
		dlg.ascbtn				= d.getElementById( "ascendButton" );
		dlg.clrbtn				= d.getElementById( "clearButton" );
		dlg.custbtn				= d.getElementById( "customButton" );
		dlg.decbtn				= d.getElementById( "decendButton" );
		dlg.hlpbtn				= d.getElementById( "helpButton" );
		dlg.movebtn				= d.getElementById( "moveButton" );
		dlg.s1					= d.getElementById( "select1" );
		dlg.s2					= d.getElementById( "select2" );
		dlg.s3					= d.getElementById( "select3" );
		dlg.srtbtn				= d.getElementById( "sortButton" );
		dlg.usrtbtn				= d.getElementById( "unsortButton" );
		dlg.cancelbtn			= d.getElementById( "cancelButton" );
		dlg.s1.firstclick		= false;
					
		dlg.srtbtn.submit = function sortsubmit()
		{
			var url = iwp.cgiPath();
			var src = dlg.s2.options;
			for ( i = 0; i < src.length; ++i )
			{
				var index = i + 1;
				url += "-sortfield." + index + "=" + src[i].indx +
						"&-sortorder." + index + "=" + src[i].value + "&";
			}
			url += "-iwpsort";
			var bFrame = iwp.bodyFrame;
			if( bFrame != null )
				bFrame.location = url;
			top.close();
		}
		
		dlg.usrtbtn.submit = function unsortsubmit()
		{
			iwp.submitAndContinue( [{target: "-submitclose", n: "-unsort", v: ""}] );
			top.close();
		}
		
		dlg.moveitems = function moveitems()
		{
			if ( this.s1active == true )
			{
				var src = this.s1.options;
				var dest = this.s2.options;
				var cnt = 0;
				for ( var i = 0; i < src.length; ++i )
				{
					if ( src[i].selected )
					{
						if ( src[i].dupcheck(dest) )
						{
							src[i].selected = false;
							var tmp = this.makeoption(src[i].text,src[i].value,src[i].indx);
							tmp.setinfo();
							dest[dest.length] = tmp;
							++cnt;
						}
					}
				}
				if ( cnt > 0 )
				{
					this.s1.blur();
					this.s2.handlefocus();
					this.clearFocus();
				}
			}
			else if ( this.s1active == false )
				this.clear( false );
		}

		dlg.s1.unselect = dlg.s2.unselect = function unselect()
		{
			for ( var i = 0; i < this.options.length; ++i ) this.options[i].selected = false;
		}
		
		dlg.s1.selectcount = dlg.s2.selectcount = function selectcount()
		{
			var cnt = 0;
			for ( var i = 0; i < this.options.length; ++i ) 
			{
				if ( this.options[i].selected ) ++cnt;
			}
			return cnt;
		}

		dlg.clear = function clear( all )
		{	
			var src = this.s2.options;
			
			if( all )
			{
				for ( var i = 0; i < src.length; ++i ) src[i--] = null;
			}
			else
			{
				for ( var i = 0; i < src.length; ++i )
				{
					if ( src[i].selected )
						src[i--] = null;
				}
			}
			
			this.clearFocus();
		}

		dlg.clearFocus = function clearFocus()
		{
			this.s1.unselect();
			this.s2.unselect();
			dlg.s1active = null;
			this.disablesortradios(true);
			dlg.movebtn.value = strs.sort_btn_move;
			dlg.movebtn.disabled = true;
			this.clearsortbuttons();
			this.s1.firstclick = false;
		}
		
		dlg.s1.handlefocus = dlg.s2.handlefocus = function handlefocus()
		{
			this.selections = this.selectcount();
			if( this.selections > 0 )
			{
				var olist, txt;
				if ( this.id == dlg.s1.id )
				{
					dlg.s1active = true;
					olist = dlg.s2;
					txt = strs.sort_btn_move;
					if (this.firstclick == false )
					{
						dlg.ascbtn.checked = true;
						this.firstclick = true;
					}
				}
				else
				{
					dlg.s1active = false;
					olist = dlg.s1;
					txt = strs.sort_btn_clear;
				}
				
				olist.selections = 0;
				olist.unselect();
			
				dlg.disablesortradios(false);
				dlg.movebtn.value = txt;
			
			}
			this.focus();
		}

		dlg.s2.setsortorder = function setsortorder()
		{				
			if ( dlg.s1active == false )
			{
				for ( var i = 0; i < this.options.length; ++i )
				{
					if(this.options[i].selected)
						this.options[i].setinfo();
				}
			}
			if ( dlg.custbtn.checked && ! dlg.custbtn.disabled )
				dlg.s3.disabled = false;
			else
				dlg.s3.disabled = true;
		}

		dlg.s2.updatesortstate = function updatesortstate()
		{
			if ( dlg.s1active == false )
			{
				var s2 = this.options;
				var sel = new Array();
				for ( var i = 0, j = 0; i < s2.length; ++i )
				{
					if ( s2[i].selected )
						sel[j++] = s2[i];
				}
				if ( sel.length > 0 )
				{
					var cval = sel[0].value;
					for ( var i = 1; i < sel.length; ++i )
					{
						if ( sel[i].value != cval )
						{
							dlg.clearsortbuttons();
							return;
						}
					}
					sel[sel.length - 1].updatesortbuttons();
				}
			}
		}
		
		dlg.clearsortbuttons = function clearsortbuttons()
		{
			this.ascbtn.checked = false;
			this.decbtn.checked = false;
			this.custbtn.checked = false;
			this.s3.disabled = true;
		}

		dlg.disablesortradios = function disablesortradios(dis)
		{
			if ( dis != null )
			{
				this.ascbtn.disabled = dis;
				this.decbtn.disabled = dis;
				this.custbtn.disabled = dis;
				if( ! dis && this.custbtn.checked  )
					this.s3.disabled = false;
				else
					this.s3.disabled = true;
				this.updatebuttons();
			}
		}
		
		dlg.updatebuttons = function updatebuttons()
		{
			var s1len = this.s1.options.length;
			var s2len = this.s2.options.length;
			
			if ( this.s1.selections > 0 || this.s2.selections > 0)
				this.movebtn.disabled = false;
			else
				this.movebtn.disabled = true;
			if ( s2len > 0 )
			{
				this.clrbtn.disabled = false;
				this.srtbtn.disabled = false;
			}
			else
			{
				this.clrbtn.disabled = true;
				this.srtbtn.disabled = true;
			}
		}
		
		dlg.makeoption = function makeoption(txt,val,idx)
		{
			var op = new Option();
			op.value = val;
			op.text = txt;
			op.rtext = txt;
			op.indx = idx;

			op.setinfo = function setinfo()
			{
				var sortstring;
				if ( dlg.decbtn.checked )
				{
					this.value = dlg.decbtn.value;
					sortstring = strs.sort_lbl_decend1;
				}
				else if ( dlg.custbtn.checked )
				{
					var vals = dlg.s3.options;
					for ( var i = 0; i < vals.length; ++i )
					{
						if ( vals[i].selected )
						{
							this.value = vals[i].indx;
							break;
						}
					}
					sortstring = strs.sort_lbl_custom1;
				}
				else
				{
					this.value = dlg.ascbtn.value;
					sortstring = strs.sort_lbl_ascend1;
				}
				this.text = sortstring + " " + this.rtext;
				this.selected = true;
			}

			op.initinfo = function initinfo()
			{
				var sortstring;
				if ( this.value == dlg.ascbtn.value )
					sortstring = strs.sort_lbl_ascend1;
				else if ( this.value == dlg.decbtn.value )
					sortstring = strs.sort_lbl_decend1;
				else
					sortstring = strs.sort_lbl_custom1;
				this.text = sortstring + " " + this.rtext;
			}

		//	alert user that a duplicate field is in a sort list
			op.dupcheck = function dupcheck(dest)
			{
				var result = true;
				for ( var i = 0; i < dest.length; ++i )
				{
					if ( this.text == dest[i].rtext )
					{
						alert(strs.sort_err_dup);
						result = false;
						break;
					}
				}
				return result;
			}

			op.updatesortbuttons = function updatesortbuttons()
			{
				if ( this.value == dlg.ascbtn.value )
					dlg.ascbtn.checked = true;
				else if ( this.value == dlg.decbtn.value )
					dlg.decbtn.checked = true;
				else
				{
					dlg.custbtn.checked = true;
					var opts = dlg.s3.options;
					for( var i = 0; i < opts.length; ++i )
					{
						if( opts[i].indx == this.value )
						{
							opts[i].selected = true;
							break;
						}
					}
				}
			}

			return op;
		}
		
		dlg.hlpbtn.showhelp = function showhelp()
		{
			window.open("/fmi/iwp/cgi?-gethelp&-anchor=Sorting_records","IWPHelp","top=20,left=20,height=460,width=620,fullscreen=no,location=no,menubar=no,resizable=yes,scrollbars=yes,status=no,toolbar=no");
	
		}
		
		dlg.cancelbtn.cancel = function cancel()
		{
			top.close();
		};
		
		dlg.disablesortradios(true);
		for ( var i in sflds )
			dlg.s1.options[i] = dlg.makeoption(sflds[i].name,sflds[i].name,sflds[i].index);
		if ( curord.length > 0 )
		{
			var dest = dlg.s2.options;
			for ( var i in curord )
			{
				var tmp = dlg.makeoption(curord[i].name,curord[i].order,curord[i].index);
				tmp.initinfo();
				dest[i] = tmp;
			}
			dlg.updatebuttons();
		}
		if ( svals.length == 0 )
			dlg.s3.options[0] = new Option(strs.sort_lbl_nolists);
		else
		{
			for ( var i in svals )
				dlg.s3.options[i] = dlg.makeoption(svals[i].name,svals[i].name,svals[i].index);
		}
		if( dlg.s1.options.length > 0 )
			dlg.s1.options[0].selected = true;
		dlg.s1.focus();
	}
}
